<?php

namespace VM\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use VM\ApiBundle\Entity\CompanyEmployee;

/**
 * CompanyEmployeeRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CompanyEmployeeRepository extends EntityRepository
{
    /**
     * @param $companyId
     * @param $departmentId
     * @param $employeeId
     * @return CompanyEmployee|null
     */
    public function getCompanyEmployee($companyId, $departmentId, $employeeId)
    {
        return $this->createQueryBuilder('ce')
            ->andWhere('ce.companyId = :companyId')
            ->andWhere('ce.departmentId = :departmentId')
            ->andWhere('ce.employeeId = :employeeId')
            ->setParameter('employeeId', $employeeId)
            ->setParameter('companyId', $companyId)
            ->setParameter('departmentId', $departmentId)
            ->getQuery()
            ->getOneOrNullResult()
            ;
    }


    /**
     * @param $companyId
     * @param $departmentId
     * @return array
     */
    public function getCompanyDepartmentEmployees($companyId, $departmentId)
    {
        return $this->getEntityManager()->getRepository('VMApiBundle:Employee')->createQueryBuilder('e')
            ->leftJoin('e.companyEmployees', 'ce')
            ->andWhere('ce.companyId = :companyId')
            ->andWhere('ce.departmentId = :departmentId')
            ->setParameter('companyId', $companyId)
            ->setParameter('departmentId', $departmentId)
            ->getQuery()
            ->getResult()
            ;
    }
}
